#!/bin/bash

if [ "$#" -ne 2 ]; then
    echo "Uso: $0 <PROXY_IP> <HOSTNAME>"
    exit 1
fi

PROXY_IP=$1
HOSTNAME=$2
CONFIG_FILE="/etc/zabbix/zabbix_agent2.conf"

mkdir /zabbix_files

cd /zabbix_files
echo "Baixando Arquivos..."
wget https://git.usb.org.br/infra/zabbix/raw/master/zabbix_v2/Rock%20Linux%208/agent2/7.0.1/zabbix-agent2-7.0.1-release1.el8.x86_64.rpm -P /zabbix_files
wget https://git.usb.org.br/infra/zabbix/raw/master/zabbix_v2/Rock%20Linux%208/agent2/7.0.1/zabbix-get-7.0.1-release1.el8.x86_64.rpm -P /zabbix_files
wget https://git.usb.org.br/infra/zabbix/raw/master/zabbix_v2/Rock%20Linux%208/agent2/7.0.1/zabbix-sender-7.0.1-release1.el8.x86_64.rpm -P /zabbix_files

echo "instalando zabbix-agent2..."
dnf -y install /zabbix_files/*.rpm

echo "Configurando..."
sed -i "s/^Server=.*/Server=$PROXY_IP/" "$CONFIG_FILE"
sed -i "s/^Hostname=.*/Hostname=$HOSTNAME/" "$CONFIG_FILE"
sed -i "s/^ServerActive=.*/#&/" "$CONFIG_FILE"

echo "Configurações atualizadas com sucesso no arquivo $CONFIG_FILE:"
echo "Server=$PROXY_IP"
echo "Hostname=$HOSTNAME"

systemctl start zabbix-agent2
systemctl enable zabbix-agent2
echo "Instalação Concluida"

